<?php
// Teste da API Moonfy
require_once 'gerar-pix-moonfy.php';

echo "<h1>Teste da API Moonfy</h1>";

// Dados de teste
$testData = [
    'action' => 'gerar_pix',
    'nome' => 'João Silva',
    'cpf' => '11144477735',
    'valor' => 10.00,
    'descricao' => 'Teste PIX Moonfy',
    'telefone' => '11999999999',
    'email' => 'teste@email.com'
];

echo "<h2>Dados de teste:</h2>";
echo "<pre>" . json_encode($testData, JSON_PRETTY_PRINT) . "</pre>";

echo "<h2>Testando geração de PIX:</h2>";
$result = gerarPix($testData);

echo "<h3>Resultado:</h3>";
echo "<pre>" . json_encode($result, JSON_PRETTY_PRINT) . "</pre>";

if ($result['success']) {
    echo "<h3>✅ PIX gerado com sucesso!</h3>";
    echo "<p><strong>Transaction ID:</strong> " . $result['transaction_id'] . "</p>";
    echo "<p><strong>PIX Code:</strong> " . substr($result['pix_code'], 0, 50) . "...</p>";
    echo "<p><strong>Status:</strong> " . $result['status'] . "</p>";
    
    // Testar verificação de status
    echo "<h2>Testando verificação de status:</h2>";
    $statusResult = verificarStatus($result['transaction_id']);
    echo "<pre>" . json_encode($statusResult, JSON_PRETTY_PRINT) . "</pre>";
} else {
    echo "<h3>❌ Erro ao gerar PIX:</h3>";
    echo "<p><strong>Erro:</strong> " . $result['error'] . "</p>";
}
?>

